<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\QdrantController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\StripeController;

/*
|--------------------------------------------------------------------------
| Public routes
|--------------------------------------------------------------------------
*/
Route::post('/register-user', [AuthController::class, 'register']);
Route::post('/login-user', [AuthController::class, 'login']);
Route::post('/stripe/webhook', [StripeController::class, 'webhook']);

/*
|--------------------------------------------------------------------------
| Protected routes
|--------------------------------------------------------------------------
|
| These routes require the user to be authenticated via Sanctum.
|
*/
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/dashboard-status', [AuthController::class, 'dashboardStatus']);
    Route::get('/check-subscription', [StripeController::class, 'checkSubscription']);
    
    // Qdrant routes
    Route::post('/qdrant-create', [QdrantController::class, 'createCollection']);
    Route::get('/qdrant-check/{name}', [QdrantController::class, 'checkCollection']);
    Route::delete('/qdrant-delete/{name}', [QdrantController::class, 'deleteCollection']);
    Route::post('/index-pages', [QdrantController::class, 'index']);
    Route::get('/view-indexed', [QdrantController::class, 'viewIndexed']);
    Route::post('/clear-index', [QdrantController::class, 'clearIndexed']);
    Route::post('/create-checkout-session', [StripeController::class, 'createCheckoutSession']);
});
// Route::get('/get-subscription-logs', [StripeController::class, 'getSubscriptionLogs']);
